/*
** Here is where we handle keystrokes.
** We spend a lot of time with the arrow keys, and let most other keys
** pass on through to do_keys().
** This routine is one of the application specific routines that will
** change a lot depending on the application. A word processor would
** do a lot here, for example.
*/

# define UP__ARROW		0x4800
# define DN__ARROW		0x5000
# define LF__ARROW		0x4b00
# define RT__ARROW		0x4d00
# define C_RETURN		'/r'
# define ESCAPE			0x1b
# define CTRL-C			0x03

got_key(ch,whand,vw)
int ch, whand, vw;{
		extern double orig_real, orig_imag, side_r, side_i;
		extern int make_square;
		
		switch( ch ) {
		case UP__ARROW:
			orig_imag -= side_i;
			if( make_square )
				side_r = side_i = (side_r + side_i) / 2.0;
			break;
		case DN__ARROW:
			orig_imag += side_i;
			if( make_square )
				side_r = side_i = (side_r + side_i) / 2.0;
			break;
		case RT ARROW:
			orig_real += side_r;
			if( make_square )
				side_r = side_i = (side_r + side_i) / 2.0;
			break;
		case LF ARROW:
			orig_real -= side_r;
			if ( make_square )
				side_r = side_i = (side_r + side_i) / 2.0;
			break;
		default:
				switch (ch & 0xff) {
						char str[80];
				case '+' :
						orig_real -= side_r / 2.0;
						orig_imag -= side_i / 2.0;
						side r *= 2.0;
						side_i *= 2.0;
						if( make_square )
							side_r = side__i = <side_r + side_i) / 2.0;
						break;
				case '-':
						orig_real += side_r / 4.0;
						orig_imag += side_i / 4.0;
						side_r /= 2.0;
						side_i /= 2.0;
						if( make_square )
						side_r = side_i = (side_r + side_i) / 2.0;
						break;
				case CTRL_C:
						if( show_form("Exit this program") )
							return(0);
						return(1);
				case C_RETURN:
						if( show_form("Return to whole set") )
								return (0);
						orig_real = -2.0;
						orig_imag = -2.0;
						side_r = 4.0;
						side_i = 4.0;
						back_to_first(whand, vw);
						return(0);
				default:
						do_keys(ch);
						return(0);
				}
	}
		clr_display(whand,vw);
		do_display(whand,vw);
		return(0);
}

do_keys(ch)
int ch; {
	char str[64];
	sprintf( str, "Ignoring character 0x%x\n" , ch) ;
	show_form(str);
}